implementation module StdControl


//	Clean Object I/O library, version 1.0.1

//	Access operations on WState.


import	StdList, StdTuple
import	oswindow
import	controlaccess, controlinternal, iostate, windowaccess, windowclipstate, wstateaccess


::	WState
	=	{	wIds	:: !WIDS
		,	wRep	:: !WindowHandle`
		,	wTb		:: !.OSToolbox
		}


getWindow :: !Id !(IOSt .l .p) -> (!Maybe WState, !IOSt .l .p)
getWindow windowId ioState
	# (wDevice,ioState)		= IOStGetDevice WindowDevice ioState
	  windows				= WindowSystemStateGetWindowHandles wDevice
	  (found,wsH,windows)	= getWindowHandlesWindow (toWID windowId) windows
	| not found
	= (Nothing,ioState)
	# (tb,ioState)			= getIOToolbox ioState
	# (wsH`,wsH,tb)			= retrieveWindowHandle` wsH tb
	# (wids,wsH)			= getWindowStateHandleWIDS wsH
	  windows				= setWindowHandlesWindow wsH windows
	# ioState				= setIOToolbox tb ioState
	# ioState				= IOStSetDevice (WindowSystemState windows) ioState
	= (Just {wIds=wids,wRep=wsH`,wTb=OSNewToolbox},ioState)

setWindow :: !Id ![IdFun *WState] !(IOSt .l .p) -> IOSt .l .p
setWindow windowId fs ioState
	# (wDevice,ioState)		= IOStGetDevice WindowDevice ioState
	  windows				= WindowSystemStateGetWindowHandles wDevice
	  (found,wsH,windows)	= getWindowHandlesWindow (toWID windowId) windows
	| not found
	= ioState
	# (tb,ioState)			= getIOToolbox ioState
	# (wsH`,wsH,tb)			= retrieveWindowHandle` wsH tb
	# (wids,wsH)			= getWindowStateHandleWIDS wsH
	# {wRep=wsH`,wTb=tb}	= StrictSeq fs {wIds=wids,wRep=wsH`,wTb=tb}
	  wsH					= insertWindowHandle` wsH` wsH
	  windows				= setWindowHandlesWindow wsH windows
	# ioState				= setIOToolbox tb ioState
	# ioState				= IOStSetDevice (WindowSystemState windows) ioState
	= ioState


//	Show/Hide controls.

showControls :: ![Id] !*WState -> *WState
showControls ids wState
	= setControlsShowState` True ids wState

hideControls :: ![Id] !*WState -> *WState
hideControls ids wState
	= setControlsShowState` False ids wState

setControlsShowState` :: !Bool ![Id] !*WState -> *WState
setControlsShowState` show ids wState=:{wIds={wPtr},wRep,wTb}
	# (wH,tb)	= setcontrolsshowstate ids show wPtr wRep wTb
	  wH		= invalidateWindowClipState` wH
	= {wState & wRep=wH,wTb=tb}


//	Enabling/Disabling of controls.

enableControls :: ![Id] !*WState -> *WState
enableControls ids wState=:{wIds={wPtr},wRep,wTb}
	# (wH,tb)	= enablecontrols ids False wPtr wRep wTb
	= {wState & wRep=wH,wTb=tb}

disableControls :: ![Id] !*WState -> *WState
disableControls ids wState=:{wIds={wPtr},wRep,wTb}
	# (wH,tb)	= disablecontrols ids False wPtr wRep wTb
	= {wState & wRep=wH,wTb=tb}


//	Marking/Unmarking of check controls.

markCheckControlItems :: !Id ![Index] !*WState -> *WState
markCheckControlItems id indexs window
	= setControlsMarkState` Mark id indexs window

unmarkCheckControlItems :: !Id ![Index] !*WState -> *WState
unmarkCheckControlItems id indexs window
	= setControlsMarkState` NoMark id indexs window

setControlsMarkState` :: !MarkState !Id ![Index] !*WState -> *WState
setControlsMarkState` mark id indexs wState=:{wIds={wPtr},wRep,wTb}
	# (wH,tb)	= setcontrolsmarkstate id mark indexs wPtr wRep wTb
	= {wState & wRep=wH,wTb=tb}


//	Selecting/Unselecting a radio control.

selectRadioControlItem :: !Id !Index !*WState -> *WState
selectRadioControlItem id index wState=:{wIds={wPtr},wRep,wTb}
	# (wH,tb)	= selectradiocontrol id index wPtr wRep wTb
	= {wState & wRep=wH,wTb=tb}


//	Select a pop up menu item.

selectPopUpControlItem :: !Id !Index !*WState -> *WState
selectPopUpControlItem id index wState=:{wIds={wPtr},wRep,wTb}
	# (wH,tb)	= selectpopupitem id index wPtr wRep wTb
	= {wState & wRep=wH,wTb=tb}


//	Move the orientation of a CompoundControl.

moveControlViewFrame :: !Id Vector !*WState -> *WState
moveControlViewFrame id v wState=:{wIds={wPtr},wRep,wTb}
	# (wH,tb)	= movecontrolviewframe id v wPtr wRep wTb
	  wH		= invalidateWindowClipState` wH
	= {wState & wRep=wH,wTb=tb}


//	Change the text of (Text/Edit/Button)Control.

setControlTexts :: ![(Id,String)] !*WState -> *WState
setControlTexts texts wState=:{wIds={wPtr},wRep,wTb}
	# (wH,tb)	= setcontroltexts texts wPtr wRep wTb
	= {wState & wRep=wH,wTb=tb}


//	Set the cursor position of an EditControl.

setEditControlCursor :: !Id !Int !*WState -> *WState
setEditControlCursor id pos wState=:{wIds={wPtr},wRep,wTb}
	# (wH,tb)	= seteditcontrolcursor id pos wPtr wRep wTb
	= {wState & wRep=wH,wTb=tb}


/*	Change the Look and redraw the corresponding (CustomButton/Custom/Compound)Controls
	only if the Boolean is True.
*/
setControlLooks :: ![(Id,Bool,Look)] !*WState -> *WState
setControlLooks looks wState=:{wIds={wPtr},wRep,wTb}
	# (wH,tb)	= setcontrolslook looks wPtr wRep wTb
	= {wState & wRep=wH,wTb=tb}


//	Change the SliderState and redraw the settings of the SliderControls.

setSliderStates :: ![(Id,SliderState->SliderState)] !*WState -> *WState
setSliderStates id_fs wState=:{wIds={wPtr},wRep,wTb}
	# (wH,tb)	= setsliderstates id_fs wPtr wRep wTb
	= {wState & wRep=wH,wTb=tb}


//	Change the thumb value of the SliderState of a SliderControl. 

setSliderThumbs :: ![(Id,Int)] !*WState -> *WState
setSliderThumbs thumbs window
	= setSliderStates (map (\(id,thumb)->(id,\state->{state & sliderThumb=thumb})) thumbs) window


//	Draw in a (Custom(Button)/Compound)Control.

drawInControl :: !Id ![DrawFunction] !*WState -> *WState
drawInControl controlId drawFs wState=:{wIds={wPtr},wRep,wTb}
	# (wH,tb)	= drawincontrol controlId drawFs wPtr wRep wTb
	= {wState & wRep=wH,wTb=tb}


//	Access operations on WState:

getWStateControls :: !WState -> [WElementHandle`]
getWStateControls {wRep={whItems`}}
	= whItems`

getControlTypes :: !WState -> [(ControlType,Maybe Id)]
getControlTypes wstate
	= getcontrolstypes (getWStateControls wstate)

getCompoundTypes :: !Id !WState -> [(ControlType,Maybe Id)]
getCompoundTypes id wstate
	= getcompoundstypes id (getWStateControls wstate)


// snd3thd3	:: !(.a,.b,.c) -> (.b,.c)								// (t2,t3) of (t1,t2,t3)
snd3thd3 tuple :== (t2,t3) where (_,t2,t3) = tuple

getControlLayouts :: ![Id] !WState -> [(Bool,(Maybe ItemPos,ItemOffset))]
getControlLayouts ids wstate
	= map snd3thd3 (snd (getcontrolslayouts (getWStateControls wstate) (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= (Nothing,zero)

getControlViewSizes :: ![Id] !WState -> [(Bool,Size)]
getControlViewSizes ids wstate
	= map snd3thd3 (snd (getcontrolsviewsizes (getWStateControls wstate) (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= zero

getControlSelectStates :: ![Id] !WState -> [(Bool,SelectState)]
getControlSelectStates ids wstate
	= map snd3thd3 (snd (getcontrolsselects (getWStateControls wstate) (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= Able

getControlShowStates :: ![Id] !WState -> [(Bool,Bool)]
getControlShowStates ids wstate
	= map snd3thd3 (snd (getcontrolsshowstates (getWStateControls wstate) (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= False

getControlTexts :: ![Id] !WState -> [(Bool,Maybe String)]
getControlTexts ids wstate
	= map snd3thd3 (snd (getcontrolstexts (getWStateControls wstate) (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= Nothing

getControlNrLines :: ![Id] !WState -> [(Bool,Maybe NrLines)]
getControlNrLines ids wstate
	= map snd3thd3 (snd (getcontrolsnrlines (getWStateControls wstate) (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= Nothing

getControlLooks :: ![Id] !WState -> [(Bool,Maybe Look)]
getControlLooks ids wstate
	= map snd3thd3 (snd (getcontrolslooks (getWStateControls wstate) (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= Nothing

getControlMinimumSizes :: ![Id] !WState -> [(Bool,Maybe Size)]
getControlMinimumSizes ids wstate
	= map snd3thd3 (snd (getcontrolsminsizes (getWStateControls wstate) (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= Nothing

getControlResizes :: ![Id] !WState -> [(Bool,Maybe ControlResizeFunction)]
getControlResizes ids wstate
	= map snd3thd3 (snd (getcontrolsresizes (getWStateControls wstate) (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= Nothing

getRadioControlItems :: ![Id] !WState -> [(Bool,Maybe [TextLine])]
getRadioControlItems ids wstate
	= map snd3thd3 (snd (getradioitems (getWStateControls wstate) (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= Nothing

getRadioControlSelection :: ![Id] !WState -> [(Bool,Maybe Index)]
getRadioControlSelection ids wstate
	= map snd3thd3 (snd (getradiocontrolsmarks (getWStateControls wstate) (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= Nothing

getCheckControlItems :: ![Id] !WState -> [(Bool,Maybe [TextLine])]
getCheckControlItems ids wstate
	= map snd3thd3 (snd (getcheckitems (getWStateControls wstate) (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= Nothing

getCheckControlSelection :: ![Id] !WState -> [(Bool,Maybe [Index])]
getCheckControlSelection ids wstate
	= map snd3thd3 (snd (getcheckcontrolsmarks (getWStateControls wstate) (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= Nothing

getPopUpControlItems :: ![Id] !WState -> [(Bool,Maybe [TextLine])]
getPopUpControlItems ids wstate
	= map snd3thd3 (snd (getpopupitems (getWStateControls wstate) (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= Nothing

getPopUpControlSelection :: ![Id] !WState -> [(Bool,Maybe Index)]
getPopUpControlSelection ids wstate
	= map snd3thd3 (snd (getselectedpopupitems (getWStateControls wstate) (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= Nothing

getSliderDirections :: ![Id] !WState -> [(Bool,Maybe Direction)]
getSliderDirections ids wstate
	= map snd3thd3 (snd (getslidersdirections (getWStateControls wstate) (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= Nothing

getSliderStates :: ![Id] !WState -> [(Bool,Maybe SliderState)]
getSliderStates ids wstate
	= map snd3thd3 (snd (getslidersstates (getWStateControls wstate) (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= Nothing

getControlViewFrames :: ![Id] !WState -> [(Bool,Maybe ViewFrame)]
getControlViewFrames ids wstate
	= map snd3thd3 (snd (getcontrolsframes (getWStateControls wstate) (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= Nothing

getControlViewDomains :: ![Id] !WState -> [(Bool,Maybe ViewDomain)]
getControlViewDomains ids wstate
	= map snd3thd3 (snd (getcontrolsdomains (getWStateControls wstate) (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= Nothing

getControlItemSpaces :: ![Id] !WState -> [(Bool,Maybe (Int,Int))]
getControlItemSpaces ids {wRep={whItems`,whAtts`}}
	= map snd3thd3 (snd (getcontrolsspaces spaces whItems` (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= Nothing
	wMetrics	= fst (OSDefaultWindowMetrics OSNewToolbox)
	hSpace		= wMetrics.osmHorItemSpace
	vSpace		= wMetrics.osmVerItemSpace
	spaces		= getWindowItemSpace` (snd (Select isWindowItemSpace` (WindowItemSpace` hSpace vSpace) whAtts`))

getControlMargins :: ![Id] !WState -> [(Bool,Maybe ((Int,Int),(Int,Int)))]
getControlMargins ids {wRep={whItems`,whAtts`}}
	= map snd3thd3 (snd (getcontrolsmargins (hMargins,vMargins) whItems` (ids,map (\id->(id,defaultBool,defaultValue)) ids)))
where
	defaultBool	= False
	defaultValue= Nothing
	wMetrics	= fst (OSDefaultWindowMetrics OSNewToolbox)
	hMargin		= wMetrics.osmHorMargin
	vMargin		= wMetrics.osmVerMargin
	hMargins	= getWindowHMargin` (snd (Select isWindowHMargin` (WindowHMargin` hMargin hMargin) whAtts`))
	vMargins	= getWindowVMargin` (snd (Select isWindowVMargin` (WindowVMargin` vMargin vMargin) whAtts`))
